#!/bin/bash

base_path=$0
function LOG() {
  if [[ ${base_path} =~ '/usr/bin/' ]]; then
    logger "$@"
  else
    command /bin/echo $(date +'%FT%T') "$@"
  fi
}

if [[ ! -f "/proc/device-tree/is_chassis" ]]; then
  LOG "Skip password upgrade script, not a DCP chassis."
  exit 0
fi

function usage {
    cat <<EOM
Usage: $(basename "$0") [OPTION]...

  -h, --help                       display help
EOM

  exit 2
}

# convert long options to getopt short ones
for arg in "$@"; do
  shift
  case "$arg" in
    "--help")                set -- "$@" "-h" ;;
    "--directory")           set -- "$@" "-d" ;;
    *)                       set -- "$@" "$arg"
  esac
done

PERSISTENT_DIRECTORY=''

# A POSIX variable
OPTIND=1         # Reset in case getopts has been used previously in the shell.

while getopts "h?d:" opt; do
  case "$opt" in
    h|\?)
      usage
      exit 0
      ;;
    esac
done

shift $((OPTIND-1))

[ "${1:-}" = "--" ] && shift


# Redis-profile
[ -r /etc/profile.d/redis.sh ] && . /etc/profile.d/redis.sh

if [[ -z ${REDIS_CONF_HASH_TAG} ]]; then
  LOG "Undefined: REDIS_CONF_HASH_TAG"
  exit 1
fi

[ -z "${REDIS_PORT}" ] && REDIS_PORT=40001
CLI_BIN="/usr/bin/redis-cli"

LOG "Triggered: ${base_path} REDIS_PORT=${REDIS_PORT}"

#Call delete_redis_key with redis port and config/password that we want to delete.
delete_redis_key -p $REDIS_PORT -k "*config/password" 

exit 0