#!/bin/bash

if [[ ! -f "/proc/device-tree/dcpm32csozrplus" ]]; then
  exit 0
fi

SCRIPTS_DIR=$(readlink -f $0 | xargs dirname)

# Define the Redis path
key="${REDIS_CONF_HASH_TAG}:dh/cloopcrx:config/client/1/rx/adminStatus"
if [[ ! -f "${SCRIPTS_DIR}/cloop_gen1_to_gen2_upgrade.lua" ]]; then
  LOG "Script ${SCRIPTS_DIR}/cloop_gen1_to_gen2_upgrade.lua does not exist. Aborting."
  THROW 1 "Cannot find upgrade script Aborting."
fi

result=$(redis-cli -c -p 30001 --eval ${SCRIPTS_DIR}/cloop_gen1_to_gen2_upgrade.lua "${REDIS_CONF_HASH_TAG}")

if [[ $result == Failed:* || $result == ERR* ]]; then
  error_message="${result#Failed: }"
  LOG "Failed to upgrade to new cloop: ${error_message}"
  THROW 1 "Failed to upgrade to new cloop: ${error_message}"
fi

if [[ $result != Success:* ]]; then
  LOG "Upgrade did not succeed: ${result}"
  THROW 1 "Upgrade did not succeed: Unexpected error."
fi
LOG "Upgrade result: ${result}"
