#!/bin/bash

script_name=$(basename "$0")

function set_edfa_adminStatus() {
  local admin_path="$1"
  data_tags=$(redis-cli -p 50002 get "${REDIS_DATA_HASH_TAG}":so:mounts | jq -r '.[] | to_entries | .[] | select(.value.instance_type=="DATA" and .value.node_type!="Chassis") | .value.tag')
  readarray -t data_tags_array <<< "$data_tags"
  for slot_tag in "${data_tags_array[@]}"; do
    path="${slot_tag}:dh/system/info:inventory/productName"
    slot_product_name=$(redis-cli -c -p 50002 dh.get "${path}" | jq -r '.value')
    if [[ -n "$slot_product_name" ]]; then
      LOG "$script_name: Will check adminStatus for $slot_product_name"
    else
      LOG "Error: Could not read product name from database"
      THROW 1 "Could not read slot module product data. Not possible to upgrade."
    fi
    if [[ "$slot_product_name" == "DCP-F-A22" || "$slot_product_name" == "DCP-F-VG" ]]; then
      slot_conf_tag="${slot_tag%??}C}"
      admin_status=$(redis-cli -c -p 50001 dh.get ${slot_conf_tag}:dh${admin_status_path} | jq -r '.value')
      if [ -n "$admin_status" ]; then
        admin_value="{\"value\":${admin_status}}"
      else
        admin_value="{\"value\":true}"
      fi
      result=$(redis-cli -c -p 30001 dh.set ${slot_conf_tag}:dh${admin_path} $admin_value)
      if [[ "$result" != "OK" ]]; then
        LOG "Error: failed to write to booster adminStatus to database"
        THROW 1 "Did not write to database. Not possible to upgrade."
      fi
      LOG "$script_name: Edfa adminStatus is set to $admin_status"
    fi
  done
  return 0
}

automode_path="/system/settings:config/automationMode"
admin_status_path="/traffic_manager:booster/config/enable"
automationMode=$(redis-cli -c -p 50001 dh.get ${REDIS_CONF_HASH_TAG}:dh${automode_path} | jq -r '.value')
LOG "$script_name: Read automationmode: $automationMode for path $automode_path before upgrade"
if [[ "$automationMode" == "embeddedILA" || "$automationMode" == "embedded" || -z "${automationMode+x}" ]]; then
  set_edfa_adminStatus "$admin_status_path"
  if [ $? -eq 0 ]; then
    LOG "$script_name: All EDFA adminStatus have been set"
  else
    THROW 1 "Not possible to convert data. Not possible to upgrade."
  fi
fi
LOG "$script_name: Successfully completed dcp2 EDFA adminStatus upgrade script."
exit 0
