#!/bin/bash

if [[ ! -f "/proc/device-tree/is_chassis" ]]; then
  exit 0
fi

LOG "Running LLDP upgrade script."
lldp=$(redis-cli -c -p 50001 dh.get "${REDIS_CONF_HASH_TAG}":dh/network:config/eth_sfp_1/lldp/fake_info | jq -r '.value')
if test -z "$lldp"; then 
    LOG "No fake LLDP on target"
    exit 1; 
fi;

lldp_hostname=$(echo "${lldp}" | jq -r '.[].chassis | keys[0]')
lldp_deg=$(echo "${lldp}" | jq  -rc --arg h "$lldp_hostname" '.[].chassis | .[$h].descr' | jq '.node.index')
lldp_ip=$(echo "${lldp}" | jq  -rc --arg h "$lldp_hostname" '.[].chassis | .[$h]."mgmt-ip"')
lldp_mac=$(echo "${lldp}" | jq  -rc --arg h "$lldp_hostname" '.[].chassis | .[$h].id.value')

lldp_new=$(jq --null-input --arg lldp_host "$lldp_hostname" --arg lldp_deg "$lldp_deg" --arg lldp_ip "$lldp_ip" --arg lldp_mac "$lldp_mac" '."remote sys name"=$lldp_host | ."remote mgmt address" = $lldp_ip  | ."remote degree" = $lldp_deg | ."remote chassis id" = $lldp_mac')
lldp_new=$(echo "[" "$lldp_new" "]");

new_redis=$(jq --null-input --arg lldp "$lldp_new" '.value=$lldp')

LOG "Upgrading fake LLDP."
LOG "$new_redis"
redis-cli -c -p 30001 dh.set "${REDIS_CONF_HASH_TAG}":dh/network:config/eth_sfp_1/lldp/fake_info "$new_redis"
LOG "Done."
exit 0