#!/bin/bash

script_name=$(basename "$0")

if [[ (! -f "/proc/device-tree/dcp2") && (! -f "/proc/device-tree/dcpm2") ]]; then
  LOG "This is not an DCP-2 nor DCP-M2"
  exit 0
fi

if [[ -f "/proc/device-tree/dcp2" ]]; then
  automode_path="/system/settings:config/automationMode"
elif [[ -f "/proc/device-tree/dcpm2" ]]; then
  automode_path="/cloop:config/automationMode"
else
  LOG "Error: Could not determine device type"
  THROW 1 "Could not determine type of device. Not possible to upgrade."
fi
automation_mode=$(redis-cli -c -p 50001 dh.get ${REDIS_CONF_HASH_TAG}:dh${automode_path} | jq -r '.value')
LOG "$script_name: Read automationmode: $automation_mode for path $automode_path before upgrade"
if [[ "$automation_mode" == "embeddedILA" ]]; then
   automation_mode="embedded"
fi
if [ -n "$automationMode" ]; then
  automation_mode="${automation_mode}"
else
  automation_mode="embedded"
fi
automation_mode_value="{\"value\":\"${automation_mode}\"}"
LOG "$script_name: to set automation mode to ${automation_mode_value}"
result=$(redis-cli -c -p 30001 dh.set ${REDIS_CONF_HASH_TAG}:dh${automode_path} ${automation_mode_value})
if [[ "$result" != "OK" ]]; then
  LOG "Error: failed to write to automation mode to database"
  THROW 1 "Not possible to write to database. Not possible to upgrade."
fi
LOG "$script_name: Automation mode upgrade script has set automation mode to $automation_mode for path $automode_path"
LOG "$script_name: Successfully completed dcp2/dcpm2 automation mode upgrade script."
exit 0
