#!/bin/sh

base_path=$0
function LOG() {
  echo $(date +'%FT%T') ${base_path} "$@"
}

#Based on mfgtools/Profiles/Linux/OS Firmware/files/partition_emmc.sh & mfgtools/Profiles/Linux/OS Firmware/files/partition_emmc_single_qspi_flash.sh
MMCDEV=/dev/mmcblk3
MMCPART=p1
MMCHOMEPART=p2
TMP_MOUNT_POINT=/tmp/mmc-tmpfs/

if [ -e /var/persistent/etc/disable_emmc_repair ]
then
    exit 0
fi

if [ -f /proc/device-tree/dcp101 ] || [ -f /proc/device-tree/dcp404 ]
then
    exit 0
fi

NEED_TO_RUN=$(mount | grep 'tmpfs on /mnt/mmc type tmpfs')
if [ -z "$NEED_TO_RUN" ]
then
    exit 0
fi

umount /mnt/mmc
umount_ret_code=$?

ISDUAL=$(mount | grep ubi1:board_info) 
ISSINGLE=$(mount | grep ubi0:board_info)
if [ ! -z "$ISDUAL" ] 
then
    LOG "is dual QSPI"
    if [ ! -b $MMCDEV$MMCPART ] || [ -b $MMCDEV$MMCHOMEPART ]
    then
        echo "2048," | sfdisk $MMCDEV
    fi
elif [ ! -z "$ISSINGLE"  ] #single
then
    LOG "is singel QSPI"
    if [ ! -b $MMCDEV$MMCHOMEPART ]
    then
        echo -e "2048,2500MiB,L\n,,L" | sfdisk $MMCDEV
        mkfs.f2fs -f $MMCDEV$MMCHOMEPART
    fi
else
    LOG "Failed to detect either dual or single QSPI: $(/bin/mount)"
    exit 0
fi

mkfs.f2fs -f $MMCDEV$MMCPART
mkfs_ret_code=$?

if [ -f "/proc/device-tree/is_chassis" ]; then
    if [ $mkfs_ret_code -ne 0 ]; then
        LOG "Failed to format: $MMCDEV$MMCPART"
        # Stop upgrading
        exit 1
    fi

    # If /mnt/mmc mount point is busy, move it to another place
    if [ $umount_ret_code -ne 0 ]; then
        mkdir -p $TMP_MOUNT_POINT
        mount --move /mnt/mmc/ $TMP_MOUNT_POINT
    fi

    mount -o rw,sync $MMCDEV$MMCPART /mnt/mmc
    if [ $? -ne 0 ]; then
        LOG "Failed to mount: $MMCDEV$MMCPART"
        # revert
        if mountpoint -q ${TMP_MOUNT_POINT}; then
            mount --move $TMP_MOUNT_POINT /mnt/mmc/
        fi
        # Stop upgrading
        exit 1
    fi

    MOUNT_SUCCESS=$(mount | grep '/mnt/mmc type f2fs')
    if [ -z "$MOUNT_SUCCESS" ]; then
        LOG "Failed to mount $MMCDEV$MMCPART"
        # revert
        if mountpoint -q ${TMP_MOUNT_POINT}; then
            mount --move $TMP_MOUNT_POINT /mnt/mmc/
        fi
        # Stop upgrading
        exit 1
    fi
else
    mount -o rw,sync $MMCDEV$MMCPART /mnt/mmc
fi

# We do this again to ensure the mountpoint is created.
MMC_MOUNT_POINT=/mnt/mmc
if mountpoint -q ${MMC_MOUNT_POINT}
then
   LOG "Mount point ${MMC_MOUNT_POINT} existed: $(/bin/mount | grep ${MMC_MOUNT_POINT})"
else
   LOG "Mount point ${MMC_MOUNT_POINT} not existed. Mounting the ${MMC_MOUNT_POINT} on ramdisk"
   mount -t tmpfs -o mode=0755 -o size=50m tmpfs ${MMC_MOUNT_POINT}
fi

mkdir /mnt/mmc/software_images
mkdir /mnt/mmc/firmware_images
mkdir /mnt/mmc/debug
mkdir /mnt/mmc/log/
echo "Detected as non formatted. Formatting done" >> /mnt/mmc/log/persistent.log
sync

exit 0